<?php

namespace App\Actions;

use DateTimeImmutable;

class CountFriday13
{
    /**
     * Вернет все пятницы 13 в году
     * @param int $year год, в котором необходимо произвести расчет
     * @return DateTimeImmutable[]
     */
    public static function count(int $year): array
    {
        $AllFri13 = [];

        for ($i = 1; $i <= 12; $i++) {
            $next13 = (new DateTimeImmutable())->setDate($year, $i, 13);

            if ($next13->format("D") === "Fri") {
                $AllFri13[] = $next13;
            }
        }
        return $AllFri13;
    }
}
